from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_cors import CORS
from config.config import Config

db = SQLAlchemy()

def create_app(config_class=Config):
    app = Flask(__name__, template_folder='templates', static_folder='static', static_url_path='/static')
    app.config.from_object(config_class)

    db.init_app(app)
    CORS(app)

    
    from routes.routes import tracking_bp
    app.register_blueprint(tracking_bp)

    return app