from flask import Blueprint, request, jsonify, render_template, session
import uuid, json
from models.models import TrackingEvent, db
from datetime import datetime

tracking_bp = Blueprint('tracking', __name__)

@tracking_bp.before_app_request
def assign_tracking_session():
    if 'tracking_id' not in session:
        session['tracking_id'] = str(uuid.uuid4())

@tracking_bp.route('/track', methods=['POST'])
def track():
    data = request.get_json()
    event, msg = TrackingEvent.addEvent(session, data, request)
    return jsonify(success=event, message=msg)

@tracking_bp.route('/collect', methods=['POST'])
def collect_tracking():
    try:
        data = request.get_json() or {}

        event = TrackingEvent(
            session_id=data.get('session_id'),
            user_id=data.get('user_id'),
            page_url=data.get('page_url'),
            page_title=data.get('page_title'),
            referrer=data.get('referrer'),
            language=data.get('language'),
            user_agent=data.get('user_agent'),
            screen_resolution=data.get('screen_resolution'),
            platform=data.get('platform'),
            browser=data.get('browser'),
            browser_version=data.get('browser_version'),
            os=data.get('os'),
            os_version=data.get('os_version'),
            country=data.get('country'),
            city=data.get('city'),
            ip_address=request.remote_addr,
            utm_source=data.get('utm_source'),
            utm_medium=data.get('utm_medium'),
            utm_campaign=data.get('utm_campaign'),
            scroll_depth=data.get('scroll_depth', 0),
            time_spent=data.get('time_spent', 0),
            clicks=json.dumps(data.get('clicks', [])),
            custom_events=json.dumps(data.get('custom_events', [])),
            errors=json.dumps(data.get('errors', [])),
            timestamp=datetime.now()
        )

        db.session.add(event)
        db.session.commit()

        return jsonify({"status": "success"}), 201

    except Exception as e:
        return jsonify({"status": "error", "message": str(e)}), 500

@tracking_bp.route('/dashboard')
def dashboard():
    recent_events = TrackingEvent.query.order_by(TrackingEvent.timestamp.desc()).limit(100).all()
    return render_template('dashboard.html', events=recent_events)